% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_datasets.R
\name{write_datasets}
\alias{write_datasets}
\title{Write Package Datasets}
\usage{
write_datasets(
  package,
  destdir = getwd(),
  overwrite = TRUE,
  include = NULL,
  exclude = NULL,
  pretty = TRUE,
  quiet = FALSE
)
}
\arguments{
\item{package}{'character' string.
Name of a package.}

\item{destdir}{'character' string.
Destination directory to write files, with tilde-expansion performed.}

\item{overwrite}{'logical' flag.
Whether to overwrite an existing file.}

\item{include}{'character' vector.
Names(s) of datasets to include.
By default, a file is created for each package dataset.}

\item{exclude}{'character' vector.
Name(s) of datasets to exclude.
By default, none are excluded.}

\item{pretty}{'logical' flag.
Whether to add indentation, whitespace, and newlines to JSON output (default is \code{TRUE}).
See \code{\link[jsonlite:prettify]{prettify}} function for details.
The tradeoff for human-readable output is a much larger file size.}

\item{quiet}{'logical' flag.
Whether to suppress printing of debugging information.}
}
\value{
Invisibly returns the output file path(s).
}
\description{
Write content of package datasets to non-proprietary, open, documented standard
file formats that are more likely to be accessible in the future.
Requires that the \pkg{jsonlite} package is available.
}
\details{
A simple-feature dataset (class 'sf' or 'sfc') is written to a GeoJSON file.
A spatial-raster dataset (class 'SpatRaster' or 'PackedSpatRaster') is written to a GeoTIFF file.
A non-spatial dataset is written to a JSON file.
}
\examples{
dir <- tempfile("")
write_datasets(
  package = "inldata",
  destdir = dir,
  include = c("crs", "dl", "inl"),
  pretty = FALSE,
  quiet = TRUE
)

unlink(dir, recursive = TRUE)
}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
\keyword{internal}
