% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot.R
\name{gg.inla.mesh.1d}
\alias{gg.inla.mesh.1d}
\title{Geom for inla.mesh.1d objects}
\usage{
\method{gg}{inla.mesh.1d}(
  data,
  mapping = ggplot2::aes(.data[["x"]], .data[["y"]]),
  y = 0,
  shape = 4,
  ...
)
}
\arguments{
\item{data}{An inla.mesh.1d object.}

\item{mapping}{aesthetic mappings created by \code{aes}. These are passed on to \code{geom_point}.}

\item{y}{Single or vector numeric defining the y-coordinates of the mesh knots to plot.}

\item{shape}{Shape of the knot markers.}

\item{...}{parameters passed on to \code{geom_point}.}
}
\value{
An object generated by \code{geom_point}.
}
\description{
This function generates a \code{geom_point} object showing the knots (vertices)
of a 1D mesh.
Requires the \code{ggplot2} package.
}
\examples{
\donttest{
# Some features use the INLA package.
if (require("INLA", quietly = TRUE) &&
  require("ggplot2", quietly = TRUE)) {

  # Create a 1D mesh

  mesh <- inla.mesh.1d(seq(0, 10, by = 0.5))

  # Plot it

  ggplot() +
    gg(mesh)

  # Plot it using a different shape and size for the mesh nodes

  ggplot() +
    gg(mesh, shape = "|", size = 5)
}
}

}
\seealso{
Other geomes for meshes: 
\code{\link{gg.inla.mesh}()},
\code{\link{gg}()},
\code{\link{gm}()}
}
\concept{geomes for meshes}
