% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.shrimp.R
\docType{data}
\name{shrimp}
\alias{shrimp}
\title{Blue and red shrimp in the Western Mediterranean Sea}
\format{
A list of objects:
\describe{
\item{\code{haul}:}{ A \code{SpatialPointsDataFrame} object containing haul locations}
\item{\code{mesh}:}{ An \code{inla.mesh} object containing a Delaunay triangulation
mesh (a type of discretization of continuous space) covering the haul locations.}
\describe{
\item{\code{catch}}{Catch in Kg.}
\item{\code{landing}}{Landing in Kg.}
\item{\code{depth}}{Mean depth of the fishery haul.}
}
}
}
\source{
Pennino, Maria Grazia. Personal communication.
}
\usage{
data(shrimp)
}
\description{
Blue and red shrimp in the Western Mediterranean Sea.
}
\examples{
\donttest{
data(shrimp, package = "inlabru")
ggplot() +
  gg(shrimp$mesh) +
  gg(shrimp$hauls) +
  coord_equal()
}
}
\references{
Pennino, M. G., Paradinas, I., Munoz, F., Illian, J.,Quilez-Lopez, A., Bellido, J.M., Conesa,
D. Accounting for preferential sampling in species distribution models. Ecology and Evolution,  In Press.
}
