% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_ndayslost.R
\name{calc_ndayslost}
\alias{calc_ndayslost}
\title{Calculate number of days lost}
\usage{
calc_ndayslost(injd, by = NULL, overall = TRUE)
}
\arguments{
\item{injd}{\code{injd} \strong{S3} object (see
\code{\link[=prepare_all]{prepare_all()}}).}

\item{by}{Character specifying the name of the column according to which
compute summary statistics. It should refer to a (categorical) variable
that describes a grouping factor (e.g. "type of case or injury", "injury
location", "sports club"). Optional, defaults to \code{NULL}.}

\item{overall}{Logical, whether to calculate overall (for all the cohort) or
athlete-wise summary statistic (i.e. number of cases per cohort of per
athlete). Defaults to \code{TRUE}.}
}
\value{
The number of days lost. Either a numeric value (if overall \code{TRUE})
or a data frame indicating the number of cases per athlete.
}
\description{
Calculate the number of days lost due to a sports-related health problem
(e.g. injuries) in a cohort during a period.
}
\examples{
calc_ndayslost(injd)
calc_ndayslost(injd, overall = FALSE)
calc_ndayslost(injd, by = "injury_type")
}
