% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getEffFactor.R
\name{getEffFactor}
\alias{getEffFactor}
\title{Construct the Matrix from Information Decomposition and Compute the
Efficiency Factors of Treatment effects}
\usage{
getEffFactor(z, T, N, Rep, trt.Sca)
}
\arguments{
\item{z}{a matrix containing the orthogonal projector of a stratum
generated by \code{\link{makeOrthProjectors}}.}

\item{T}{a list of contrast matrices generated by
\code{\link{makeContrMat}}.}

\item{N}{a matrix containing the design matrix generated by
\code{\link{makeOverDesMat}}.}

\item{Rep}{a matrix containing the treatment replication number and is
generated by \code{\link{getTrtRep}}.}

\item{trt.Sca}{a numeric vector for computing a coefficients of the fixed
effect parameter in EMS and is generated by \code{\link{getTrtRep}}.}
}
\value{
A list of matrices and numeric vectors containing the efficiency
factors of every treatment effect.
}
\description{
Perform the information decomposition for either the block or treatment
effects within a single stratum and Compute the Efficiency Factors for
every treatment effect within a single stratum.
}
\details{
The main purpose of this function is to construct a list of resultant
matrices associated with each source of variation after the information
decomposition and to compute the canonical or average efficiency factors
for each treatment effects in each stratum of ANOVA table.

The canonical efficiency factors are generated when the user input the
treatment contrasts, otherwise the average efficiency factors, which is the
harmonic mean of the canonical efficiency factors, are generated.
}
\examples{

design1 <- local({ 
  Ani = as.factor(LETTERS[c(1,2,3,4,
                            5,6,7,8)])
  Trt = as.factor(letters[c(1,1,1,1,
                            2,2,2,2)])
  data.frame(Ani, Trt)
})

blk.str = "Ani"
    
rT = terms(as.formula(paste("~", blk.str, sep = "")), keep.order = TRUE) 
blkTerm = attr(rT,"term.labels")
     
Z = makeBlkDesMat(design1, blkTerm)

trt.str = "Trt"              
fT <- terms(as.formula(paste("~", trt.str, sep = "")), keep.order = TRUE)  #fixed terms

trtTerm <- attr(fT, "term.labels")
effectsMatrix <- attr(fT, "factor")        

T <- makeContrMat(design1, trtTerm, effectsMatrix, contr.vec = NA)

N =  makeOverDesMat(design1, trtTerm)

Replist = getTrtRep(design1, trtTerm)   
 
Rep <- Replist$Rep
trt.Sca <- Replist$Sca
    
effFactors = lapply(makeOrthProjectors(Z), function(z) 
      getEffFactor(z, T, N, Rep, trt.Sca))


}
\author{
Kevin Chang
}
