% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{spreading.score}
\alias{spreading.score}
\title{Spreading score}
\usage{
spreading.score(
  graph,
  vertices = V(graph),
  weights = NULL,
  directed = FALSE,
  mode = "all",
  loops = TRUE,
  d = 3,
  scaled = TRUE
)
}
\arguments{
\item{graph}{A graph (network) of the igraph class.}

\item{vertices}{A vector of desired vertices, which could be obtained by the V function.}

\item{weights}{Optional positive weight vector for calculating weighted betweenness centrality
of nodes as a requirement for calculation of IVI. If the graph has a weight edge attribute,
then this is used by default. Weights are used to calculate weighted shortest paths,
so they are interpreted as distances.}

\item{directed}{Logical scalar, whether to directed graph is analyzed. This argument
is ignored for undirected graphs.}

\item{mode}{The mode of Spreading score depending on the directedness of the graph.
If the graph is undirected, the mode "all" should be specified.
Otherwise, for the calculation of Spreading score based on
incoming connections select "in" and for the outgoing connections select "out".
Also, if all of the connections are desired, specify the "all" mode. Default mode is set to "all".}

\item{loops}{Logical; whether the loop edges are also counted.}

\item{d}{The distance, expressed in number of steps from a given node (default=3). Distance
must be > 0. According to Morone & Makse (https://doi.org/10.1038/nature14604), optimal
results can be reached at d=3,4, but this depends on the size/"radius" of the network.
NOTE: the distance d is not inclusive. This means that nodes at a distance of 3 from
our node-of-interest do not include nodes at distances 1 and 2. Only 3.}

\item{scaled}{Logical; whether the end result should be 1-100 range normalized or not (default is TRUE).}
}
\value{
A numeric vector with Spreading scores.
}
\description{
This function calculates the Spreading score of the desired nodes from a graph.
Spreading score reflects the spreading potential of each node within a network and is
one of the major components of the IVI.
}
\examples{
\dontrun{
MyData <- coexpression.data
My_graph <- graph_from_data_frame(MyData)
GraphVertices <- V(My_graph)
Spreading.score <- spreading.score(graph = My_graph, vertices = GraphVertices,
                                   weights = NULL, directed = FALSE, mode = "all",
                                   loops = TRUE, d = 3, scaled = TRUE)
}
}
\seealso{
\code{\link[influential]{hubness.score}}
}
\keyword{spreading.score}
