% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shade_confidence_interval.R
\name{shade_confidence_interval}
\alias{shade_confidence_interval}
\alias{shade_ci}
\title{Add information about confidence interval}
\usage{
shade_confidence_interval(
  endpoints,
  color = "mediumaquamarine",
  fill = "turquoise",
  ...
)

shade_ci(endpoints, color = "mediumaquamarine", fill = "turquoise", ...)
}
\arguments{
\item{endpoints}{A 2 element vector or a 1 x 2 data frame containing the
lower and upper values to be plotted. Most useful for visualizing
conference intervals.}

\item{color}{A character or hex string specifying the color of the
end points as a vertical lines on the plot.}

\item{fill}{A character or hex string specifying the color to shade the
confidence interval. If \code{NULL} then no shading is actually done.}

\item{...}{Other arguments passed along to \\{ggplot2\\} functions.}
}
\value{
A list of \\{ggplot2\\} objects to be added to the \code{visualize()}
output.
}
\description{
\code{shade_confidence_interval()} plots confidence interval region on top of the
\code{\link[=visualize]{visualize()}} output. It should be used as \\{ggplot2\\} layer function (see
examples). \code{shade_ci()} is its alias.

Learn more in \code{vignette("infer")}.
}
\examples{
# find the point estimate---mean number of hours worked per week
point_estimate <- gss \%>\%
  specify(response = hours) \%>\%
  calculate(stat = "mean") \%>\%
  dplyr::pull()
  
# ...and a null distribution
null_dist <- gss \%>\%
  # ...we're interested in the number of hours worked per week
  specify(response = hours) \%>\%
  # hypothesizing that the mean is 40
  hypothesize(null = "point", mu = 40) \%>\%
  # generating data points for a null distribution
  generate(reps = 1000, type = "bootstrap") \%>\%
  # finding the null distribution
  calculate(stat = "mean")
  
# find a confidence interval around the point estimate
ci <- null_dist \%>\%
  get_confidence_interval(point_estimate = point_estimate,
                          # at the 95\% confidence level
                          level = .95,
                          # using the standard error method
                          type = "se")   
  
  
# and plot it!
null_dist \%>\%
  visualize() +
  shade_confidence_interval(ci)
  
# or just plot the bounds
null_dist \%>\%
  visualize() +
  shade_confidence_interval(ci, fill = NULL)

# More in-depth explanation of how to use the infer package
\dontrun{
vignette("infer")
}

}
\seealso{
\code{\link[=shade_p_value]{shade_p_value()}} to add information about p-value region.
}
