% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fn_case.R
\name{fn_case}
\alias{fn_case}
\title{Case statements applying a function to all inputs}
\usage{
fn_case(x, fn, ..., preserve = FALSE, default = NA)
}
\arguments{
\item{x}{A vector}

\item{fn}{A function to apply to the left-hand side of each formula in \code{...}

Either a quoted or unquoted function name, an anonymous \code{\link{function}}, or
a \link[rlang:as_function]{purrr-style formula}.

The function should take two inputs, the first being \code{x} and the second
being the left-hand side of the formula.
The function should return a logical vector, either of length 1 or the same
length as \code{x}.}

\item{...}{<\code{\link[rlang:dyn-dots]{dynamic-dots}}> A sequence of two-sided
formulas or named arguments.
\itemize{
\item \strong{Formulas}: Elements of \code{x} that return \code{TRUE} when passed to \code{fn} with
the left hand side (LHS) of each formula will be replaced with the value in
the right hand side (RHS).
The LHS must evaluate to a logical vector when passed to \code{fn} with \code{x}.
The RHS must be of length 1 or the same length as all other RHS.
\item \strong{Named arguments}: named arguments are passed as additional arguments
to the function \code{fn}.
}}

\item{preserve}{If \code{TRUE}, unmatched elements of \code{x} will be returned
unmodified.
(The elements may have their type coerced to be compatible with
replacement values.)
If \code{FALSE}, unmatched elements of \code{x} will be replaced with \code{default}.
Defaults to \code{FALSE}.}

\item{default}{If \code{preserve} is \code{FALSE}, a value to replace unmatched
elements of \code{x}.
Defaults to \code{NA}.}
}
\value{
A vector of length 1 or n, matching the length of the logical input
or output vectors.
Inconsistent lengths will generate an error.
}
\description{
Case statements applying a function to all inputs
}
\examples{
# Replicate switch_case()
parties <- sample(c("d", "r", "i", "g", "l"), 20, replace = TRUE)

fn_case(
  parties,
  fn = `\%in\%`,
  "d" ~ "Democrat",
  "r" ~ "Republican",
  "i" ~ "Independent",
  "g" ~ "Green",
  "l" ~ "Libertarian"
)

# Replicate grep_case()
countries <- c(
  "France", "Ostdeutschland", "Westdeutschland", "Nederland",
  "Belgie (Vlaanderen)", "Belgique (Wallonie)", "Luxembourg", "Italia"
)

fn_case(
  countries,
  fn = function(x, pattern, ...) {grepl(pattern, x, ...)},
  "Deutschland" ~ "Germany",
  "Belgi(qu)?e" ~ "Belgium",
  "Nederland"   ~ "Netherlands",
  "Italia"      ~ "Italy",
  preserve      = TRUE,
  ignore.case   = TRUE
)

fn_case(
  countries,
  fn = stringi::stri_detect_regex,
  "Deutschland"    ~ "Germany",
  "Belgi(qu)?e"    ~ "Belgium",
  "Nederland"      ~ "Netherlands",
  "Italia"         ~ "Italy",
  preserve         = TRUE,
  case_insensitive = TRUE
)

# Recode values in a range
time    <- runif(10, 1, 12)
hours   <- time \%/\% 1
minutes <- time \%\% 1 * 60

hours <- hours \%>\%
  if_case(minutes > 32.5, (. + 1) \%\% 12, .) \%>\%
  switch_case(0 ~ 12, preserve = TRUE) \%>\%
  nombre::cardinal()

minutes \%>\%
  fn_case(
    fn = ~ abs(.x - .y) <= 2.5,
    0  ~ "o'clock",
    60 ~ "o'clock",
    30 ~ "half past",
    15 ~ "quarter past",
    45 ~ "quarter to",
    5  ~ "five past",
    10 ~ "ten past",
    20 ~ "twenty past",
    25 ~ "twenty-five past",
    55 ~ "five to",
    50 ~ "ten to",
    40 ~ "twenty to",
    35 ~ "twenty-five to"
  ) \%>\%
  switch_case(
    "o'clock" ~ paste(hours, .),
    default   = paste(., hours)
  )

# Replicate vctrs::vec_ptype_abbr() (used for tibble column labels)
# Based on a contribution by Patrice Kiener
in_herits <- function(x) {
  fn_case(
    x, inherits,
    "factor"     ~ "fct",
    "character"  ~ "chr",
    "numeric"    ~ "dbl",
    "integer"    ~ "int",
    "logical"    ~ "lgl",
    "complex"    ~ "cpl",
    "raw"        ~ "raw",
    "matrix"     ~ "mat",
    "array"      ~ "arr",
    "data.frame" ~ "df",
    "list"       ~ "lst",
    "function"   ~ "fn",
    default      = class(x)[[1]]
  )
}

in_herits(1:3)
in_herits(letters[1:3])
in_herits(fn_case)
}
\seealso{
\code{\link[=fn_case_fct]{fn_case_fct()}} to return a factor and
\code{\link[=fn_case_list]{fn_case_list()}} to return a list

\code{\link[=fn_switch_case]{fn_switch_case()}}, which applies a function to each formula's LHS,
but not \code{x}

\code{\link[=switch_case]{switch_case()}}, a simpler alternative for exact matching

\code{\link[=grep_case]{grep_case()}}, a simpler alternative for \link{regex} pattern matching

\code{\link[=in_case]{in_case()}}, a pipeable alternative to \code{\link[dplyr:case_when]{dplyr::case_when()}}
}
