% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_data.R
\name{check_data}
\alias{check_data}
\title{Checks the data for consistency with the inbreedR working format.}
\usage{
check_data(genotypes, num_ind = NULL, num_loci = NULL)
}
\arguments{
\item{genotypes}{\code{data.frame} (or \code{matrix}) with individuals in rows and loci in columns,
containing genotypes coded as \code{0} (homozygote), \code{1} (heterozygote) and \code{NA} (missing)}

\item{num_ind}{Number of individuals}

\item{num_loci}{Number of loci / markers}
}
\value{
TRUE if the data format is correct, error message if any test failed
}
\description{
The \code{inbreedR} working format is an i * l genotype matrix, whereby each individual is a row 
and each column is a locus.
Heterozygosity at a given locus should be coded as \code{1}, homozygosity as \code{0} and missing values
should be coded as \code{NA}.
}
\details{
Checks that (1) the genotype data just contains 3 elements, which is \code{0} for homozygote,
         \code{1} for heterozygote and \code{NA} for missing data, (2) the number 
         of individuals corresponds to the number of rows and the number of loci corresponds to the
         number of columns, (3) the data type is numeric.
     .
}
\examples{
data(mouse_msats)
# tranform raw genotypes into 0/1 format
genotypes <- convert_raw(mouse_msats)
# check data
check_data(genotypes, num_ind = 36, num_loci = 12)


}
\author{
Martin A. Stoffel (martin.adam.stoffel@gmail.com)
}

