% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis.imputations.R
\name{vis.imputations}
\alias{vis.imputations}
\title{Visualize the Imputed Values}
\usage{
vis.imputations(ts.withNA, ts.withImpuations, ts.withTruth = NULL,
  legend = T, ...)
}
\arguments{
\item{ts.withNA}{Time Series (\code{\link{ts}}) object with NAs before imputation}

\item{ts.withImpuations}{Time Series (\code{\link{ts}}) object with NAs replaced by imputed values}

\item{ts.withTruth}{Time Series (\code{\link{ts}}) object with the real values. (only for imputation algortihm tests)}

\item{legend}{Adds a legend above the plot if set to TRUE.}

\item{...}{Additional graphical parameters like e.g. main}
}
\description{
Visualize the imputed values in a time series. Optional: For imputation
algorithm tests, with manuelly deleted values the the real values can be included.
}
\examples{
##Example 1
#Load dataset
require(datasets)
data(AirPassengers)

#Create dataset with NAs
airp.na <- AirPassengers
airp.na[c(3:5,5,60:65,80,110:117)] <- NA

#Perform imputation using na.mean
airp.imp <- na.mean(airp.na)

#Visualize the imputed values
vis.imputations(airp.na, airp.imp)


##Example 2
#Load dataset
require(datasets)
data(AirPassengers)

airp.na <- airp.truth <- AirPassengers

#Create dataset with NAs
airp.na[c(3:5,5,60:65,80,110:117)] <- NA

#Perform imputation using na.mean
airp.imp <- na.mean(airp.na)

#Visualize the imputed values
vis.imputations(airp.na, airp.imp, airp.truth)
}
\author{
Steffen Moritz
}

