% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_imputeMulti.R
\docType{class}
\name{mod_imputeMulti-class}
\alias{mod_imputeMulti-class}
\title{Class "mod_imputeMulti"}
\description{
A multivariate multinomial model imputed by EM or Data Augmentation is 
represented as a \code{\linkS4class{mod_imputeMulti}} object. A complete 
dataset and model is represented as an \code{\linkS4class{imputeMulti}} object.
Slots for \code{mod_imputeMulti} objects include: (1) the modeling method; 
(2) the call to the estimation function; (3) the number of iterations in estimation;
(4) the final log-likelihood; (5) the conjugate prior if any; (6) the MLE estimate of
the sufficient statistics and parameters.
}
\section{Slots}{

\describe{
\item{\code{method}}{the modeling method}

\item{\code{mle_call}}{the call to the estimation function}

\item{\code{mle_iter}}{the number of iterations in estimation}

\item{\code{mle_log_lik}}{the final log-likelihood}

\item{\code{mle_cp}}{the conjugate prior if any}

\item{\code{mle_x_y}}{the MLE estimate of the sufficient statistics and parameters}
}}
\section{Objects from the class}{
 Objects are created by calls to
\code{\link{multinomial_impute}}, \code{\link{multinomial_em}}, or
\code{\link{multinomial_data_aug}}.
}

\section{Methods}{

\code{\link{summary,mod_imputeMulti-method}}
}
\seealso{
\code{\link{multinomial_impute}}, \code{\link{multinomial_em}}, 
\code{\link{multinomial_data_aug}}
}

