% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multinomial_em.R
\name{multinomial_em}
\alias{multinomial_em}
\title{EM algorithm for multinomial data}
\usage{
multinomial_em(x_y, z_Os_y, enum_comp, n_obs, conj_prior = c("none",
  "data.dep", "flat.prior", "non.informative"), alpha = NULL, tol = 5e-07,
  max_iter = 10000, verbose = FALSE)
}
\arguments{
\item{x_y}{A \code{data.frame} of observed counts for complete observations.}

\item{z_Os_y}{A \code{data.frame} of observed marginal-counts for incomplete observations.}

\item{enum_comp}{A \code{data.frame} specifying a vector of all possible observed patterns.}

\item{n_obs}{An integer specifying the number of observations in the original data.}

\item{conj_prior}{A string specifying the conjugate prior. One of
\code{c("none", "data.dep", "flat.prior", "non.informative")}.}

\item{alpha}{The vector of counts \eqn{\alpha} for a \eqn{Dir(\alpha)} prior. Must be specified if
\code{conj_prior} is either \code{c("data.dep", "flat.prior")}. If \code{flat.prior}, specify
as a scalar. If \code{data.dep}, specify as a vector with key matching \code{enum_comp}.}

\item{tol}{A scalar specifying the convergence criteria. Defaults to \code{5e-7}}

\item{max_iter}{An integer specifying the maximum number of allowable iterations. Defaults
to \code{10000}.}

\item{verbose}{Logical. If \code{TRUE}, provide verbose output on each iteration.}
}
\value{
An object of class \code{\link{mod_imputeMulti-class}}.
}
\description{
Implement the EM algorithm for multvariate multinomial data given
observed counts of complete and missing data (\eqn{Y_obs} and \eqn{Y_mis}). Allows for specification
of a Dirichlet conjugate prior.
}
\examples{
\dontrun{
 data(tract2221)
 x_y <- multinomial_stats(tract2221[,1:4], output= "x_y")
 z_Os_y <- multinomial_stats(tract2221[,1:4], output= "z_Os_y")
 x_possible <- multinomial_stats(tract2221[,1:4], output= "possible.obs")

 imputeEM_mle <- multinomial_em(x_y, z_Os_y, x_possible, n_obs= nrow(tract_2221),
                     conj_prior= "none", verbose= TRUE)
}

}
\seealso{
\code{\link{multinomial_data_aug}}, \code{\link{multinomial_impute}}
}

