% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/non_wear.R
\name{summarise_nonwear}
\alias{summarise_nonwear}
\title{Summarise accelerometer non-wear time}
\usage{
summarise_nonwear(data, min_hour_crit, min_day_crit, save_summary)
}
\arguments{
\item{data}{An \code{impactr_data} object with the \code{wear} column, as
obtained with \link[=mark_nonwear]{mark_nonwear()}.}

\item{min_hour_crit}{The minimum number of hours marked as wear time
in a day for it to be considered valid.}

\item{min_day_crit}{The minimum number of valid days for the data of
a given subject to be considered valid.}

\item{save_summary}{Indicates whether of not to save the wear time
daily summary to a csv file. Provide a valid path to a file ending
with the ".csv" extension as a character string if you want the
summary to be saved.}
}
\value{
The \code{impactr_data} object provided by \code{data} with the
\code{wear} column values updated based on the validations. If no data are
classified as valid, it returns \code{NULL}. Also saves the summary
in a csv file if \code{save_summary} is a path.
}
\description{
Validates each measurement day based on the minimum number of wear hours
and validates the entire observation based on the minimum number of valid
days. It updates the values of the \code{wear} column (created by
\link[=mark_nonwear]{mark_nonwear()}) of the \code{impactr_data} object
provided by \code{data}, marking as non-wear time the days considered to
be invalid. It also creates a wear time daily summary that can be saved in
a csv file.
}
\details{
This is an internal function, designed to be used inside the wrapper
function \link[=remove_nonwear]{remove_nonwear()} that integrates all
steps of detection, removal and inspection of accelerometer non-wear time.
}
\seealso{
\code{\link[=detect_nonwear]{detect_nonwear()}},
\code{\link[=plot_nonwear]{plot_nonwear()}},
\code{\link[=mark_nonwear]{mark_nonwear()}},
\code{\link[=delete_nonwear]{delete_nonwear()}}
}
\keyword{internal}
