% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid.R
\name{gridPanel}
\alias{gridPanel}
\title{Create a panel with a CSS grid layout}
\usage{
gridPanel(
  ...,
  template = NULL,
  areas = NULL,
  rows = NULL,
  columns = NULL,
  gap = NULL,
  align_items = "stretch",
  justify_items = "stretch",
  auto_fill = TRUE,
  breakpoint_system = activeBreakpoints(),
  id = generateID()
)
}
\arguments{
\item{...}{Elements to include within the panel. If areas are used, named
named arguments using the grid area name will be added to that grid area.
If no named arguments or areas are used, non attribute elements will be
added to existing grid cells based on their order.}

\item{template}{The name of the template to use as a base for the grid.
See listTemplates() and registerTemplate() for more information.}

\item{areas}{A list of vectors with area names, or a vector or strings
representing each row of the grid. Each element should contain
the names, per row, of each area of the grid. Expected values follow the
convension for the grid-template-areas css attribute.
for example c("area-1 area-1", "area-2 area-3") and
list(c("area-1", "area-1"), c(area-2", "area-3")) are both valid
representations of a 2x2 grid with 3 named areas.
If using breakpoints, a named list of valid values where each name is a
valid breakpoint can be used as well.
For example list( default = c("area-1", "area-2"),
xs = list(c("area-1"), c("area-2"))) would be a valid value
for breakpoints}

\item{rows}{A string of css valid sizes separated by a space. or a vector of
sizes. For example both "1fr 2fr" or c("1fr", "2fr") are valid
representations of the same 2 rows grid sizes.
Follows the convension for the grid-template-rows css attribute.
If not provided the existing space will be split equally acording to the
areas defined in areas.
Supports named list for breakpoints.}

\item{columns}{A string of css valid sizes separated by a space. or a vector
of sizes. For example both "1fr 2fr" or c("1fr", "2fr") are valid
representations of the same 2 columns grid sizes.
Follows the convension for the grid-template-columns css attribute.
If not provided the existing space will be split equally acording to the
areas defined in areas.
Supports named list for breakpoints.}

\item{gap}{The space (in a valid css size) between each grid cell.
Supports named list for breakpoints.}

\item{align_items}{The cell behavior according to the align-items css
property. Defaults to stretch.
Supports named list for breakpoints.}

\item{justify_items}{The cell behavior according to the justify-items css
property. Defaults to stretch.
Supports named list for breakpoints.}

\item{auto_fill}{Should the panel stretch to fit its parent size (TRUE), or
should its size be based on its children element sizes (FALSE).}

\item{breakpoint_system}{Optional Media breakpoints to use. Will default to
the current active breakpoint system.}

\item{id}{The html id of the panel container.}
}
\value{
An HTML tagList.
}
\description{
Create a panel with a CSS grid layout
}
\details{
Behaves similar to normal HTML div tags, but simplifies
  the way css grid can be used via the arguments area, rows and columns.
  Only areas is required, when not used rows and columns will simply split
  the existing space equaly between each row / column.
  Internally the function creates the styles for the grid positions by
  generating the rules for positioning the children via their classes.
  To position a child element simply make sure that it includes a class
  with the same name as the named area.
}
\note{
When creating responsive layouts based on media rules, for arguments
  a named list can be passed instead of a single value. The names in the list
  can be any of the registered breakpoints available in activeBreakpoints().
  Breakpoints can also be modified with the registerBreakpoint() and
  unregisterBreakpoint() functions. Arguments that allow this are: areas |
  rows | columns | gap.

See \url{https://css-tricks.com/snippets/css/complete-guide-grid/}
  for additional details on using css grids
}
\examples{
if (interactive()) {
library(imola)
gridPanel(
  areas = c("area-1 area-1", "area-2 area-3"),
  rows = "1fr 2fr",
  columns = "2fr 100px",
  div(class = "area-1"),
  div(class = "area-2"),
  div(class = "area-3")
)
}

}
\seealso{
[gridPage()]

Other grid functions: 
\code{\link{gridPage}()}
}
\concept{grid functions}
