% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotation.R
\name{dbLoad}
\alias{dbLoad}
\title{Load clonotype databases such as VDJDB and McPAS into the R workspace}
\usage{
dbLoad(.path, .db, .species = NA, .chain = NA, .pathology = NA)
}
\arguments{
\item{.path}{Character. A path to the database file, e.g., "/Users/researcher/Downloads/McPAS-TCR.csv".}

\item{.db}{Character. A database type: either "vdjdb", "vdjdb-search", "mcpas" or "tbadb".

"vdjdb" for VDJDB; "vdjdb-search" for search table obtained from the web interface of VDJDB;
"mcpas" for McPAS-TCR; "tbadb" for PIRD TBAdb.}

\item{.species}{Character. A string or a vector of strings specifying which species need to be in the database, e.g., "HomoSapiens".
Pass NA (by default) to load all available species.}

\item{.chain}{Character. A string or a vector of strings specifying which chains need to be in the database, e.g., "TRB".
Pass NA (by default) to load all available chains.}

\item{.pathology}{Character. A string or a vector of strings specifying which disease, virus, bacteria or any condition
needs to be in the database, e.g., "CMV".
Pass NA (by default) to load all available conditions.}
}
\value{
Data frame with the input database records.
}
\description{
The function automatically detects the database format and loads it into R.
Additionally, the function provides a general query interface to databases that allows
filtering by species, chain types (i.e., locus) and pathology (i.e., antigen species).

Currently we support three popular databases:

VDJDB - \url{https://github.com/antigenomics/vdjdb-db}

McPAS-TCR - \url{http://friedmanlab.weizmann.ac.il/McPAS-TCR/}

TBAdb from PIRD - \url{https://db.cngb.org/pird/}
}
\examples{
# Example file path
file_path <- paste0(system.file(package = "immunarch"), "/extdata/db/vdjdb.example.txt")

# Load the database with human-only TRB-only receptors for all known antigens
db <- dbLoad(file_path, "vdjdb", "HomoSapiens", "TRB")
db
}
\concept{annotation}
