% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{mt_compact_data}
\alias{mt_compact_data}
\title{Calls API endpoint 'CompactData' to get Dataset time series}
\usage{
mt_compact_data(id, dimensions, start_period = NA, end_period = NA)
}
\arguments{
\item{id}{is a Dataset Series identifier.}

\item{dimensions}{is a named list with the dimensions query.}

\item{start_period}{is time series start date with formats.}

\item{end_period}{is time series end date with format.
See Details for the valid formats.}
}
\value{
a list with content of 'CompactData' response.
}
\description{
Calls API endpoint 'CompactData' to get Dataset time series
}
\details{
The 'start_period' and 'end_pariod' parameters should have formats:
'yyyy', 'yyyy-mm' or 'yyyy-mm-dd'.
}
\examples{
mt_compact_data("IFS", list("M", "GB", "PMP_IX"))
mt_compact_data("IFS", list("M", "GB", "PMP_IX"), start_period = "2000-01")
mt_compact_data("DOT", list("M","GB", "TMG_CIF_USD", c("B0","W00")))

}
