% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimulatePolicies.R
\name{SimulatePolicies}
\alias{SimulatePolicies}
\title{Simulate a data frame of policies}
\usage{
SimulatePolicies(N, PolicyYears, NumYears, Exposure = 1, Retention = 1,
  Growth = 0, StartID = 1, AdditionalColumns)
}
\arguments{
\item{N}{An integer giving the number of policies in the first year}

\item{PolicyYears}{A vector of integers in sequence}

\item{NumYears}{The number of years to simulate. If `PolicyYears` is given, this is ignored.}

\item{Exposure}{Exposure per policy}

\item{Retention}{A vector indicating loss of policies}

\item{Growth}{A vector indicating the rate of growth of policies}

\item{StartID}{Integer of the first number in the policy ID sequence}

\item{AdditionalColumns}{A list of addtional column names and values}
}
\value{
A data frame of policy data
}
\description{
Given a starting number of policies, this function will generate additional years of policy data.

Growth is given as a the positive rate of growth of new policies. This may be set to zero.

Retention is given as the portion of expiring policies which will renew.
}
