% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{imdirac}
\alias{imdirac}
\title{Generates a "dirac" image, i.e. with all values set to 0 except one.}
\usage{
imdirac(dims, x, y, z = 1, cc = 1)
}
\arguments{
\item{dims}{a vector of image dimensions, or an image whose dimensions will be used. If dims has length < 4 some guesswork will be used (see examples and ?as.cimg.array)}

\item{x}{where to put the dirac (x coordinate)}

\item{y}{y coordinate}

\item{z}{z coordinate (default 1)}

\item{cc}{colour coordinate (default 1)}
}
\value{
an image
}
\description{
This small utility is useful to examine the impulse response of a filter
}
\examples{
\dontshow{cimg.limit.openmp()}
#Explicit settings of all dimensions
imdirac(c(50,50,1,1),20,20)
imdirac(c(50,50),20,20) #Implicit
imdirac(c(50,50,3),20,20,cc=2) #RGB
imdirac(c(50,50,7),20,20,z=2) #50x50 video with 7 frames
#Impulse response of the blur filter
imdirac(c(50,50),20,20) \%>\% isoblur(sigma=2)  \%>\% plot
#Impulse response of the first-order Deriche filter
imdirac(c(50,50),20,20) \%>\% deriche(sigma=2,order=1,axis="x")  \%>\% plot
##NOT RUN, interactive only
##Impulse response of the blur filter in space-time
##resp <- imdirac(c(50,50,100),x=25,y=25,z=50)  \%>\%  isoblur(16)
###Normalise to 0...255 and play as video
##renorm(resp) \%>\% play(normalise=FALSE)
}
\author{
Simon Barthelme
}
