% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cimg_class.R
\name{cimg}
\alias{cimg}
\title{Create a cimg object}
\usage{
cimg(X)
}
\arguments{
\item{X}{a four-dimensional numeric array}
}
\value{
an object of class cimg
}
\description{
cimg is a class for storing image or video/hyperspectral data.  It is designed to provide easy interaction with the CImg library, but in order to use it you need to be aware of how CImg wants its image data stored. 
Images have up to 4 dimensions, labelled x,y,z,c. x and y are the usual spatial dimensions, z is a depth dimension (which would correspond to time in a movie), and c is a colour dimension. Images are stored linearly in that order, starting from the top-left pixel and going along *rows* (scanline order).
A colour image is just three R,G,B channels in succession. A sequence of N images is encoded as R1,R2,....,RN,G1,...,GN,B1,...,BN where R_i is the red channel of frame i.
The number of pixels along the x,y,z, and c axes is called (in that order), width, height, depth and spectrum. 
NB: Logical and integer values are automatically converted to type double. NAs are not supported by CImg, so you should manage them on the R end of things.
}
\examples{
\dontshow{cimg.limit.openmp()}
cimg(array(1,c(10,10,5,3)))
}
\author{
Simon Barthelme
}
