% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coordinates.R
\name{imcoord}
\alias{Cc}
\alias{Xc}
\alias{Yc}
\alias{Zc}
\alias{imcoord}
\title{Coordinates as images}
\usage{
Xc(im)

Yc(im)

Zc(im)

Cc(im)
}
\arguments{
\item{im}{an image}
}
\value{
another image of the same size, containing pixel coordinates
}
\description{
These functions return pixel coordinates for an image, as an image. All is made clear in the examples (hopefully)
}
\section{Functions}{
\itemize{
\item \code{Xc}: X coordinates

\item \code{Yc}: Y coordinates

\item \code{Zc}: Z coordinates

\item \code{Cc}: C coordinates
}}
\examples{
im <- imfill(5,5) #An image
Xc(im) #An image of the same size, containing the x coordinates of each pixel
Xc(im) \%>\% imrow(1)
Yc(im) \%>\% imrow(3) #y is constant along rows
Yc(im) \%>\% imcol(1)
#Mask bits of the boats image:
plot(boats*(Xc(boats) < 100))
plot(boats*(dnorm(Xc(boats),m=100,sd=30))) #Gaussian window
}
\seealso{
as.cimg.function, pixel.grid
}

