% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filtering.R
\name{imsharpen}
\alias{imsharpen}
\title{Sharpen image.}
\usage{
imsharpen(im, amplitude, type = "diffusion", edge = 1, alpha = 0,
  sigma = 0)
}
\arguments{
\item{im}{an image}

\item{amplitude}{Sharpening amplitude (positive scalar, 0: no filtering).}

\item{type}{Filtering type. "diffusion" (default) or "shock"}

\item{edge}{Edge threshold (shock filters only, positive scalar, default 1).}

\item{alpha}{Window size for initial blur (shock filters only, positive scalar, default 0).}

\item{sigma}{Window size for diffusion tensor blur (shock filters only, positive scalar, default 0).}
}
\description{
The default sharpening filter is inverse diffusion. The "shock filter" is a non-linear diffusion that has better edge-preserving properties.
}
\examples{
layout(t(1:2))
plot(boats,main="Original")
imsharpen(boats,150)  \%>\% plot(main="Sharpened")
}

