% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drawing.R
\name{selectSimilar}
\alias{selectSimilar}
\title{Select a region of homogeneous colour}
\usage{
selectSimilar(im, x, y, z = 1, sigma = 0, high_connexity = FALSE)
}
\arguments{
\item{im}{an image}

\item{x}{X-coordinate of the starting point of the region to fill.}

\item{y}{Y-coordinate of the starting point of the region to fill.}

\item{z}{Z-coordinate of the starting point of the region to fill.}

\item{sigma}{Tolerance concerning neighborhood values.}

\item{high_connexity}{Use 8-connexity (only for 2d images, default FALSE).}
}
\description{
The underlying algorithm is the same as the bucket fill (AKA flood fill). Unlike with the bucket fill, the image isn't changed, the function simply returns a binary mask of the selected region
}
\examples{
#Select part of a sail 
impart <- selectSimilar(boats,x=169,y=179,sigma=20) 
layout(t(1:2))
plot(boats,main="Original")
plot(impart,main="Selected region")
}
\seealso{
bucketfill
}

