% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text_io.R
\name{text-image-io}
\alias{text-image-io}
\alias{write_txt_img}
\alias{read_txt_img}
\title{Read/write an image array to/from disk as text file(s).}
\usage{
write_txt_img(img, path, rds = FALSE)

read_txt_img(path)
}
\arguments{
\item{img}{An image, represented by a 4-dimensional array, like an
\link{ijtiff_img}.}

\item{path}{The name of the input/output output file(s), \emph{without} a
file extension.}

\item{rds}{In addition to writing a text file, save the image as an RDS (a
single R object) file?}
}
\description{
Write images (arrays) as tab-separated \code{.txt} files on disk. Each
channel-frame pair gets its own file.
}
\examples{
\dontrun{
img <- read_tif(system.file('img', 'Rlogo.tif', package = 'ijtiff'))
write_txt_img(img, 'temp')
img <- read_txt_img('temp_ch1.txt')}

}
