% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attributes.R
\name{vertex_attr<-}
\alias{vertex_attr<-}
\alias{vertex.attributes<-}
\title{Set one or more vertex attributes}
\usage{
vertex_attr(graph, name, index = V(graph)) <- value
}
\arguments{
\item{graph}{The graph.}

\item{name}{The name of the vertex attribute to set. If missing,
then \code{value} must be a named list, and its entries are
set as vertex attributes.}

\item{index}{An optional vertex sequence to set the attributes
of a subset of vertices.}

\item{value}{The new value of the attribute(s) for all
(or \code{index}) vertices.}
}
\value{
The graph, with the vertex attribute(s) added or set.
}
\description{
Set one or more vertex attributes
}
\examples{
g <- make_ring(10)
vertex_attr(g) <- list(
  name = LETTERS[1:10],
  color = rep("yellow", gorder(g))
)
vertex_attr(g, "label") <- V(g)$name
g
plot(g)
}
\seealso{
Other graph attributes: 
\code{\link{delete_edge_attr}()},
\code{\link{delete_graph_attr}()},
\code{\link{delete_vertex_attr}()},
\code{\link{edge_attr<-}()},
\code{\link{edge_attr_names}()},
\code{\link{edge_attr}()},
\code{\link{graph_attr<-}()},
\code{\link{graph_attr_names}()},
\code{\link{graph_attr}()},
\code{\link{igraph-dollar}},
\code{\link{igraph-vs-attributes}},
\code{\link{set_edge_attr}()},
\code{\link{set_graph_attr}()},
\code{\link{set_vertex_attr}()},
\code{\link{vertex_attr_names}()},
\code{\link{vertex_attr}()}
}
\concept{graph attributes}
