% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/motifs.R
\name{triad_census}
\alias{triad_census}
\alias{triad.census}
\title{Triad census, subgraphs with three vertices}
\usage{
triad_census(graph)
}
\arguments{
\item{graph}{The input graph, it should be directed. An undirected graph
results a warning, and undefined results.}
}
\value{
A numeric vector, the subgraph counts, in the order given in the
above description.
}
\description{
This function counts the different induced subgraphs of three vertices in
a graph.
}
\details{
Triad census was defined by David and Leinhardt (see References below).
Every triple of vertices (A, B, C) are classified into the 16 possible
states: \describe{ \item{003}{A,B,C, the empty graph.} \item{012}{A->B, C,
the graph with a single directed edge.} \item{102}{A<->B, C, the graph with
a mutual connection between two vertices.} \item{021D}{A<-B->C, the
out-star.} \item{021U}{A->B<-C, the in-star.} \item{021C}{A->B->C, directed
line.} \item{111D}{A<->B<-C.} \item{111U}{A<->B->C.} \item{030T}{A->B<-C,
A->C.} \item{030C}{A<-B<-C, A->C.} \item{201}{A<->B<->C.}
\item{120D}{A<-B->C, A<->C.} \item{120U}{A->B<-C, A<->C.}
\item{120C}{A->B->C, A<->C.} \item{210}{A->B<->C, A<->C.}
\item{300}{A<->B<->C, A<->C, the complete graph.} }

This functions uses the RANDESU motif finder algorithm to find and count the
subgraphs, see \code{\link[=motifs]{motifs()}}.
}
\examples{

g <- sample_gnm(15, 45, directed = TRUE)
triad_census(g)
}
\references{
See also Davis, J.A. and Leinhardt, S.  (1972).  The Structure
of Positive Interpersonal Relations in Small Groups.  In J. Berger (Ed.),
Sociological Theories in Progress, Volume 2, 218-251.  Boston: Houghton
Mifflin.
}
\seealso{
\code{\link[=dyad_census]{dyad_census()}} for classifying binary relationships,
\code{\link[=motifs]{motifs()}} for the underlying implementation.
}
\author{
Gabor Csardi \email{csardi.gabor@gmail.com}
}
\keyword{graphs}
