% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attributes.R
\name{set_vertex_attr}
\alias{set_vertex_attr}
\alias{set.vertex.attribute}
\title{Set vertex attributes}
\usage{
set_vertex_attr(graph, name, index = V(graph), value)
}
\arguments{
\item{graph}{The graph.}

\item{name}{The name of the attribute to set.}

\item{index}{An optional vertex sequence to set the attributes
of a subset of vertices.}

\item{value}{The new value of the attribute for all (or \code{index})
vertices.
If \code{NULL}, the input is returned unchanged.}
}
\value{
The graph, with the vertex attribute added or set.
}
\description{
Set vertex attributes
}
\examples{
g <- make_ring(10) \%>\%
  set_vertex_attr("label", value = LETTERS[1:10])
g
plot(g)
}
\seealso{
Other graph attributes: 
\code{\link{delete_edge_attr}()},
\code{\link{delete_graph_attr}()},
\code{\link{delete_vertex_attr}()},
\code{\link{edge_attr<-}()},
\code{\link{edge_attr_names}()},
\code{\link{edge_attr}()},
\code{\link{graph_attr<-}()},
\code{\link{graph_attr_names}()},
\code{\link{graph_attr}()},
\code{\link{igraph-dollar}},
\code{\link{igraph-vs-attributes}},
\code{\link{set_edge_attr}()},
\code{\link{set_graph_attr}()},
\code{\link{vertex_attr<-}()},
\code{\link{vertex_attr_names}()},
\code{\link{vertex_attr}()}
}
\concept{graph attributes}
