% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/games.R
\name{sample_correlated_gnp}
\alias{sample_correlated_gnp}
\title{Generate a new random graph from a given graph by randomly
adding/removing edges}
\usage{
sample_correlated_gnp(old.graph, corr, p = old.graph$p,
  permutation = NULL)
}
\arguments{
\item{old.graph}{The original graph.}

\item{corr}{A scalar in the unit interval, the target Pearson
correlation between the adjacency matrices of the original the generated
graph (the adjacency matrix being used as a vector).}

\item{p}{A numeric scalar, the probability of an edge between two
vertices, it must in the open (0,1) interval.}

\item{permutation}{A numeric vector, a permutation vector that is
applied on the vertices of the first graph, to get the second graph.  If
\code{NULL}, the vertices are not permuted.}
}
\value{
An unweighted graph of the same size as \code{old.graph} such
that the correlation coefficient between the entries of the two
adjacency matrices is \code{corr}.  Note each pair of corresponding
matrix entries is a pair of correlated Bernoulli random variables.
}
\description{
Sample a new graph by perturbing the adjacency matrix of a given graph
and shuffling its vertices.
}
\details{
Please see the reference given below.
}
\examples{
g <- sample_gnp(1000, .1)
g2 <- sample_correlated_gnp(g, corr = 0.5)
cor(as.vector(g[]), as.vector(g2[]))
g
g2
}
\references{
Lyzinski, V., Fishkind, D. E., Priebe, C. E. (2013).  Seeded
graph matching for correlated Erdos-Renyi graphs.
\url{http://arxiv.org/abs/1304.7844}
}
\seealso{
\code{\link{sample_correlated_gnp_pair}},
  \code{\link{sample_gnp}}
}
