`ppig` <-
function(x,kernel="normal",line=FALSE,
xlab="Empirical distribution function",ylab="Theorical distribution function"){
ker<-kernel
estimados<-mleig(x,kernel=ker)
a<-estimados$mu
b<-estimados$lambda
c<-estimados$nu
nu<-c
if(kernel=="normal"){
n<-length(x)
F<-seq(1,n)
for(i in 1:n){
caux<-x[i]
Faux<-pig(caux,mu=a,lambda=b,kernel="normal")
F[i]<-Faux
}
Pemp<-sort(F)
k<-seq(1,n,by=1)
Pteo<-(k-0.5)/n
plot(Pemp,Pteo,xlab=xlab,ylab=ylab,col=4,xlim=c(0,1),ylim=c(0,1),lwd=1.5)
R<-((cor(Pemp,Pteo))^2)*100
text(0.1,1,as.expression(substitute(R^2==r,list(r=R))))
Result<-list(determination.coefficient=R)
if(line==TRUE){
lines(c(0,1),c(0,1),col=2,lwd=2.0)
}
}
if(kernel=="t"){
n<-length(x)
F<-seq(1,n)
for(i in 1:n){
caux<-x[i]
Faux<-pig(caux,mu=a,lambda=b,kernel="t",parameter.nu=c)
F[i]<-Faux
}
Pemp<-sort(F)
k<-seq(1,n,by=1)
Pteo<-(k-0.5)/n
plot(Pemp,Pteo,xlab=xlab,ylab=ylab,col=4,xlim=c(0,1),ylim=c(0,1),lwd=1.5)
R<-((cor(Pemp,Pteo))^2)*100
text(0.1,1,as.expression(substitute(R^2==r,list(r=R))))
Result<-list(determination.coefficient=R)
if(line==TRUE){
lines(c(0,1),c(0,1),col=2,lwd=2.0)
}
}
if(kernel=="logistic"){
n<-length(x)
F<-seq(1,n)
for(i in 1:n){
caux<-x[i]
Faux<-pig(caux,mu=a,lambda=b,kernel="logistic")
F[i]<-Faux
}
Pemp<-sort(F)
k<-seq(1,n,by=1)
Pteo<-(k-0.5)/n
plot(Pemp,Pteo,xlab=xlab,ylab=ylab,col=4,xlim=c(0,1),ylim=c(0,1),lwd=1.5)
R<-((cor(Pemp,Pteo))^2)*100
text(0.1,1,as.expression(substitute(R^2==r,list(r=R))))
Result<-list(determination.coefficient=R)
if(line==TRUE){
lines(c(0,1),c(0,1),col=2,lwd=2.0)
}
}
if(kernel=="Laplace"){
n<-length(x)
F<-seq(1,n)
for(i in 1:n){
caux<-x[i]
Faux<-pig(caux,mu=a,lambda=b,kernel="Laplace")
F[i]<-Faux
}
Pemp<-sort(F)
k<-seq(1,n,by=1)
Pteo<-(k-0.5)/n
plot(Pemp,Pteo,xlab=xlab,ylab=ylab,col=4,xlim=c(0,1),ylim=c(0,1),lwd=1.5)
R<-((cor(Pemp,Pteo))^2)*100
text(0.1,1,as.expression(substitute(R^2==r,list(r=R))))
Result<-list(determination.coefficient=R)
if(line==TRUE){
lines(c(0,1),c(0,1),col=2,lwd=2.0)
}
}
return(Result)
}

