% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-elements_pubchem.R
\docType{data}
\name{elements_pubchem}
\alias{elements_pubchem}
\title{Period Table of the Elements (PubChem)}
\format{
A data.table data frame with 118 rows and 17 variables:
\describe{
\item{Name}{Name of the element}
\item{Atomic Number (Z)}{Atomic number of the element}
\item{Formula}{Chemical formula of the element}
\item{Atomic Mass (u)}{Element atomic mass in the unified atomic mass unit (u)}
\item{CPK Hex Color}{Corey-Pauling-Koltun Hex color for each element)}
\item{Electron Configuration}{Element electron configuration}
\item{Electronegativity}{Element electronegativity}
\item{Atomic Radius (pm)}{Element atomic radius}
\item{Ionization Energy (eV)}{Element ionization energy}
\item{Electron Affinity (eV)}{Element electron affinity}
\item{Oxidation States}{Element oxidation states}
\item{Standard State}{Standard state of the element at standard temperature and pressure (STP)}
\item{Melting Point (K)}{Element melting point in Kelvin}
\item{Boiling Point (K)}{Element boiling point in Kelvin}
\item{Density (g/cm^3)}{Element density in grams / cubic centimeters}
\item{Group Name}{Name of the element group}
\item{Year Discovered}{Year the element was discovered}
}
}
\source{
PubChem [Internet]. Bethesda (MD): National Library of Medicine (US), National Center for Biotechnology Information; 2004-. Periodic Table of Elements; [cited 2023 May 12]. Available from: \url{https://pubchem.ncbi.nlm.nih.gov/periodic-table/}.
}
\usage{
elements_pubchem
}
\description{
A table containing the periodic table of the elements from PubChem.
}
\keyword{datasets}
