#' US EPA Secondary Drinking Water Standards
#'
#' A table containing the secondary drinking water pollutants.
#'
#'
#' @format A data.table data frame with 15 rows and 3 variables:
#' \describe{
#' \item{Contaminant}{The name of the contaminant}
#' \item{Secondary MCL}{Maximum Contaminant Level (MCL)}
#' \item{Noticeable Effects above the Secondary MCL}{What are the noticeable effects above the secondary MCL}
#' }
#'
#'
#' @source
#' United States (US) Environmental Protection Agency (EPA): "Secondary Drinking Water Standards: Guidance for Nuisance Chemicals", \url{https://web.archive.org/web/20230903054648/https://www.epa.gov/sdwa/secondary-drinking-water-standards-guidance-nuisance-chemicals}. Used the Internet Archive: Wayback Machine archived version for acceptance into CRAN.
#'
#'
#'
#'
"USA_secondary_water_contaminants"
#> [1] "USA_secondary_water_contaminants"
