% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PgivenF.R
\encoding{UTF-8}
\name{PgivenF}
\alias{PgivenF}
\alias{PgivenF}
\alias{PF}
\title{Present value given Future value (Engineering Economics)}
\usage{
PgivenF(F, n, i, frequency = c("annual", "semiannual", "quarter", "bimonth",
  "month", "daily"))

PF(F, n, i, frequency = c("annual", "semiannual", "quarter", "bimonth",
  "month", "daily"))
}
\arguments{
\item{F}{numeric vector that contains the future value(s)}

\item{n}{numeric vector that contains the period value(s)}

\item{i}{numeric vector that contains the interest rate(s) as a percent}

\item{frequency}{character vector that contains the frequency used to
obtain the number of periods [annual (1), semiannual (2), quarter (4),
bimonth (6), month (12), daily (365)]}
}
\value{
PgivenF numeric vector that contains the present value(s) rounded
   to 2 decimal places

PF data.frame of both n (0 to n) and the resulting present values
   rounded to 2 decimal places
}
\description{
Compute P given F
}
\details{
P is expressed as

\deqn{P = F\left[\frac{1}{\left(1 + i\right)^n}\right]}

\describe{
\item{\emph{P}}{the "present equivalent"}
\item{\emph{F}}{the "future equivalent"}
\item{\emph{i}}{the "effective interest rate per interest period"}
\item{\emph{n}}{the "number of interest periods"}
}
}
\examples{
library(iemisc)
# Example 4-4 from the Reference text (page 128)
PgivenF(10000, 6, 8, "annual") # the interest rate is 8\%

PF(10000, 6, 8, "annual") # the interest rate is 8\%


}
\references{
William G. Sullivan, Elin M. Wicks, and C. Patrick Koelling, \emph{Engineering Economy}, Fourteenth Edition, Upper Saddle River, New Jersey: Pearson/Prentice Hall, 2009, page 128, 142, 164.
}
