% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nc.R
\encoding{UTF-8}
\name{nc2}
\alias{nc2}
\title{Einstein and Banks method for composite Manning's n}
\usage{
nc2(P, n)
}
\arguments{
\item{P}{numeric vector that contains "wetted perimeter of any section i"}

\item{n}{numeric vector that contains "Manning's n of any section i"}
}
\value{
numeric vector that contains nc2 as Manning's composite n.
}
\description{
This function computes the composite Manning's n using the Einstein and
Banks method.
}
\details{
"A composite value of Manning's n for a single channel; that is, for the
main channel only of a compound channel or a canal with laterally varying
roughness." Source: Sturm page 118.

The equation to find Manning's composite n using the Einstein and Banks
method is

\deqn{n_c = \left[\frac{\sum \limits_{i=1}^N P_i n_i^2}{P}\right] ^ \frac{1}{2}}

\describe{
\item{\emph{\eqn{n_c}}}{Manning's composite n}
\item{\emph{P}}{"wetted perimeter of the entire cross section"}
\item{\emph{\eqn{P_i}}}{"wetted perimeter of any section i"}
\item{\emph{\eqn{n_i}}}{"Manning's n of any section i"}
\item{\emph{N}}{"total number of sections into which the wetted perimeter
       is divided"}
}

Source: Sturm page 118.
}
\examples{
library(iemisc)
# Example from the Moore Reference text
nc2(n = c(0.05, 0.035, 0.05, 0.04), P = c(22.22, 34.78, 2.00, 6.08))


}
\references{
\enumerate{
   \item Terry W. Sturm, \emph{Open Channel Hydraulics}, 2nd Edition, New York City, New York: The McGraw-Hill Companies, Inc., 2010, page 118-119.
   \item Dan Moore, P.E., NRCS Water Quality and Quantity Technology Development Team, Portland Oregon, "Using Mannings Equation with Natural Streams", August 2011, \url{http://www.wcc.nrcs.usda.gov/ftpref/wntsc/H&H/xsec/manningsNaturally.pdf}.
}
}
\seealso{
\code{\link{n}} for Manning's n for natural channels, \code{\link{nc1}} for
  Horton method for composite Manning's n, \code{\link{nc3}} for Lotter method for
  composite Manning's n, and \code{\link{nc4}} for Krishnamurthy and Christensen
  method for composite Manning's n.
}

