% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nc.R
\encoding{UTF-8}
\name{n}
\alias{n}
\title{Manning's n for natural channels}
\usage{
n(nb = NULL, n1 = NULL, n2 = NULL, n3 = NULL, n4 = NULL, m = NULL)
}
\arguments{
\item{nb}{numeric vector that contains "the base value for a straight,
uniform channel", if needed}

\item{n1}{numeric vector that contains "correction for surface
irregularities", if needed}

\item{n2}{numeric vector that contains "correction for variations in the
shape and size of the cross section", if needed}

\item{n3}{numeric vector that contains "correction for obstructions", if
needed}

\item{n4}{numeric vector that contains "correction for vegetation and
flow conditions", if needed}

\item{m}{numeric vector that contains "correction factor for channel
meandering", if needed}
}
\value{
n as Manning's n for a natural channel as a numeric vector.
}
\description{
This function computes Manning's n for natural channels.
}
\details{
"Roughness values for channels and flood plains should be determined
separately. The composition, physical shape, and vegetation of a flood
plain can be quite different from those of a channel." Source: USGS.

The equation to find Manning's n for natural channels is expressed as

\deqn{n = \left(n_b + n_1 + n_2 + n_3 + n_4\right)m}

\describe{
\item{\emph{n}}{Manning's n}
\item{\emph{\eqn{n_b}}}{"the base value for a straight, uniform channel"}
\item{\emph{\eqn{n_1}}}{"correction for surface irregularities"}
\item{\emph{\eqn{n_2}}}{"correction for variations in the shape and size
     of the cross section"}
\item{\emph{\eqn{n_3}}}{"correction for obstructions"}
\item{\emph{\eqn{n_4}}}{"correction for vegetation and flow conditions"}
\item{\emph{m}}{"correction factor for channel meandering"}
}

Source: Sturm page 114.
}
\examples{
library(iemisc)
# Example from Table 4. from the USGS Reference text page 35
n(nb = 0.025, n4 = 0.005, m = 1.00)


}
\references{
\enumerate{
   \item Terry W. Sturm, \emph{Open Channel Hydraulics}, 2nd Edition, New York City, New York: The McGraw-Hill Companies, Inc., 2010, page 114.
   \item Guide for Selecting Manning's Roughness Coefficients for Natural Channels and Flood Plains, United States Geological Survey Water-supply Paper 2339 Metric Version
   \item George J. Arcement, Jr., and Verne R. Schneider, United States Geological Survey Water-Supply Paper 2339, "Guide for Selecting Manning's Roughness Coefficients for Natural Channels and Flood Plains", 1989, \url{http://pubs.usgs.gov/wsp/2339/report.pdf}.
}
}
\seealso{
\code{\link{nc1}} for Horton method for composite Manning's n, \code{\link{nc2}} for
 Einstein and Banks method for composite Manning's n, \code{\link{nc3}} for
 Lotter method for composite Manning's n, and \code{\link{nc4}} for
 Krishnamurthy and Christensen method for composite Manning's n.
}

