% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/idem_visualize.R
\name{imPlotImputed}
\alias{imPlotImputed}
\title{Plot density of imputed values}
\usage{
imPlotImputed(imp.rst, deltas = 0, endp = FALSE, fname = NULL,
  adj = 1.5, cols = c("red", "cyan", "blue", "green", "brown"),
  ltys = rep(1, 6), xlim = NULL, ylim = NULL, mfrow = NULL, ...)
}
\arguments{
\item{imp.rst}{A class \code{IDEM.IMP} list containing complete data
with relevant missing values imputed. See \code{\link{imImpAll}}.}

\item{deltas}{Imputation sensitivity parameter for which to generate the results}

\item{endp}{If TRUE, plot the densities of the imputed functional outcomes.
Otherwise, plot the densities of the imputed outcomes}

\item{fname}{File name of the result pdf file. If \code{fname} is null,
result pdf file will not be generated}

\item{adj}{\code{density} estimation option}

\item{cols}{\code{plot} options}

\item{ltys}{\code{plot} options}

\item{xlim}{\code{plot} options}

\item{ylim}{\code{plot} options}

\item{mfrow}{\code{plot} options}

\item{...}{Options for \code{pdf} function}
}
\description{
Plot density of imputed values and the density of the observed outcomes
}
\examples{
\dontrun{
lst.var <- list(trt="TRT", surv="SURV", outcome=c("Y1","Y2"), y0=NULL,
                endp=c("Y2"), unitTime="days",
                trt.label = c("UC+SBT", "SAT+SBT"),
                cov=c("AGE"), endfml="Y2", duration=365, bounds=c(0,100));
rst.fit <- imFitModel(abc, lst.var);
rst.imp <- imImpAll(abc, rst.fit, deltas=c(-0.25,0,0.25),
                    normal=TRUE, chains = 4, iter = 2000, warmup = 1000);
imPlotImputed(rst.imp, deltas=c(-0.25,0,0.25), xlim=c(0,100), endp=FALSE);}

}
