% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grids.r
\docType{class}
\name{hexagrid}
\alias{hexagrid}
\alias{hexagrid-class}
\alias{hexagrid-initalize-method}
\alias{initialize,hexagrid-method}
\title{A penta-hexagonal icosahedral grid}
\usage{
\S4method{initialize}{hexagrid}(.Object, tessellation = 1, sp = FALSE,
  graph = TRUE, center = origin, radius = authRadius)
}
\arguments{
\item{.Object}{non-argument pointing to self.}

\item{tessellation}{An integer vector with the tessellation values. Each number
 describes the number of new edges replacing one original edge. Multiple series of tessellations
    are possible this way. The total tessellation is the product of the tessellation vector. 
Higher values result in more uniform cell sizes, but the larger number of tessellation series,
increases the speed of lookup functions}

\item{sp}{A logical value indicating whether the 'SpatialPolygons' class representation of the grid
should be added to the object when the grid is calculated. If set to true the SpPolygons() function will be run with with the resolution parameter set to 25. The 
 resulting object will be stored in slot @sp. As the calculation of this object can increase the grid creation time substantially
 by default this argument has a value FALSE. This can be added on demand by running the function \code{newsp}.}

\item{graph}{A logical value indicating whether the 'igraph' class representation of the grid
should be added to the object when the grid is calculated. This argument defaults to TRUE because this option has only minor performance load on the grid 
constructor function. For familiarization with the
object structure, however, setting this parameter to FALSE might help, as invoking str() on the 'igraph' class slot of the class might flood the console.}

\item{center}{The origin of the grid in the reference Cartesian coordinate system. Defaults to (0,0,0).}

\item{radius}{The radius of the grid. Defaults to the authalic radius of Earth.}
}
\value{
A hexagonal grid object, with class \code{hexagrid}.
}
\description{
\code{hexagrid} creates a hexa-pentagonal grid based on the inversion of a 
   tessellated icosahedron.
}
\details{
Inherits from the \code{trigrid} class.

The grid structure functions as a frame for data graining, plotting and
calculations. Data can be stored in layers that are linked to the grid object. In the current version only the 
\code{facelayer} class is implemented which allows the user to render data to the cells
of the grid which are called faces. 
	The grid 'user interface' is made up of four primary tables: the \code{@vertices} table for the coordinates of the vertices,
	the \code{faceCenters} for the coordinates of the centers of faces,
the \code{faces} and the \code{edges} tables that contain which vertices form which faces and edges respectively.
In these tables, the faces and vertices are sorted to form spirals that go from the north pole in a counter-clockwise
direction. In case grid subsetting is performed these tables get truncated.

At finer resolutions, the large number of spatial elements render all calculations very resource demanding and slow, 
therefore the hierarchical structure created during the tessellation procedure is retained for efficient implementations.
These data are stored in a list in the slot \code{@skeleton} and are 0-indexed integer tables for Rccp-based functions. \code{$v} 
stores vertex, \code{$f} the edge, and \code{$e} contains the edge data for plotting and calculations. In these tables
the original hierarchy based orderings of the units are retained, during subsetting, additional vectors are used to indicate
deactivation of these units. Any sort of meddling with the @skeleton object will lead to unexpected behavior.
}
\section{Slots}{

\describe{
\item{\code{vertices}}{Matrix of the vertex coordinates.}

\item{\code{faces}}{Matrix of the verticies forming the faces}

\item{\code{edges}}{Matrix of the vertices forming the edges.}

\item{\code{tessellation}}{Contains the tessellation vector.}

\item{\code{orientation}}{Contains the grid orientation in xyz 3d space, values in radian.}

\item{\code{center}}{The xyz coordinates of the grid's origin/center.}

\item{\code{div}}{Contains the number of faces that a single face of the previous tessellation level is decomposed to.}

\item{\code{faceCenters}}{Contains the xyz coordinates of the centers of the faces on the surface of the sphere.}
}}
\examples{
		g <- hexagrid(c(8))
		g1 <- hexagrid(c(2,3,4))
}

