% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid-lookup.R
\name{occupied}
\alias{occupied}
\title{Faces occupied by the specified object}
\usage{
occupied(gridObj, data, ...)
}
\arguments{
\item{gridObj}{(\code{\link{trigrid}} or \code{\link{hexagrid}}) An icoshedral grid.}

\item{data}{(\code{matrix}, \code{data.frame} or \code{Spatial}) The queried data.}

\item{...}{Arguments passed to the class specific methods}
}
\value{
The function Returns a \code{\link{facelayer}}-class object.
}
\description{
This function will return a \code{\link{facelayer}} class object showing which faces are occupied by the input object.
}
\details{
This is a wrapper function on the \code{OccupiedFaces} methods that are specific to grid class and input data.
}
\examples{
# create a grid
g <- trigrid(8, sp=TRUE)

# create random points
randPoints <- rpsphere(100,output="polar")

# the facelayer occupied by these points
randomLayer <- occupied(g, randPoints)
plot(randomLayer)
points(randPoints, col="blue", pch="+")


}
