% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{more}
\alias{more}
\title{Print More Rows of Ichimoku Objects}
\usage{
more(n)
}
\arguments{
\item{n}{a parameter (optional) passed on to the argument 'n' of
\code{\link[tibble]{print.tbl}} controlling the number of rows to show.
Defaults to 100. Normally an integer, but supply a character string such
as 'a' to print all rows.}
}
\value{
The ichimoku object contained in \code{\link{.Last.value}} (invisibly)
    or else invisible NULL (if .Last.value is not an ichimoku object).
    The ichimoku object data is printed to the console.
}
\description{
After calling or invoking the default print method for ichimoku objects, the
    console output will display \code{# … with x more rows} if the entire
    data does not fit on-screen. Use \code{more()} to display more rows.
}
\examples{
cloud <- ichimoku(sample_ohlc_data, ticker = "TKR")
cloud
more()
more(20)

}
