% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{df_append}
\alias{df_append}
\title{Append New Data to Dataframe}
\usage{
df_append(new, old)
}
\arguments{
\item{new}{data.frame object containing new data.}

\item{old}{data.frame object containing existing data.}
}
\value{
A data.frame of the existing data appended with the new data. If the
    data in 'new' contains data with the same value for 'time' as 'old',
    the data in 'new' will overwrite the data in 'old'.

    If the 'timestamp' attribute exists in 'new', this is retained. All other
    non-required attributes are dropped.
}
\description{
Update a 'data.frame' object with new data. Can be used to append new updated
    time series data to an existing dataframe, where each observation is indexed
    by a unique timestamp in a column headed 'time'.
}
\details{
Can be used to update price dataframes retrieved by \code{\link{oanda}}.
    The function is designed to update existing data with new values as they
    become available. As opposed to \code{\link{df_merge}}, the data in 'new'
    will overwrite the data in 'old' rather than create duplicates.
}
\examples{
data1 <- sample_ohlc_data[1:8, ]
data1
data2 <- sample_ohlc_data[7:10, ]
data2
df_append(data2, data1)

}
