% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oanda.R
\name{oanda_chart}
\alias{oanda_chart}
\title{Live Ichimoku Cloud Charts from OANDA Data}
\usage{
oanda_chart(
  instrument,
  granularity = c("D", "W", "M", "H12", "H8", "H6", "H4", "H3", "H2", "H1", "M30",
    "M15", "M10", "M5", "M4", "M2", "M1", "S30", "S15", "S10", "S5"),
  refresh = 5,
  count = 250,
  price = c("M", "B", "A"),
  theme = c("original", "dark", "solarized", "mono"),
  server = c("practice", "live"),
  apikey,
  ...
)
}
\arguments{
\item{instrument}{string containing the base currency and quote currency
delimited by a '_' (for example "USD_JPY"). Use the
\code{\link{oanda_instruments}} function to return a list of all valid
instruments.}

\item{granularity}{[default "D"] the granularity of the price data to fetch,
one of "M", "W", "D", "H12", "H8", "H6", "H4", "H3", "H2", "H1", "M30",
"M15", "M10", "M5", "M4", "M2", "M1", "S30", "S15", "S10", "S5".}

\item{refresh}{[default 5] data refresh interval in seconds, with a minimum of 1.}

\item{count}{[default 250] the number of periods to return. The API supports
a maximum of 5000 for each individual request.}

\item{price}{[default "M"] pricing component, one of "M" (midpoint), "B" (bid)
or "A" (ask).}

\item{theme}{[default 'original'] chart theme with alternative choices of
'dark', 'solarized' or 'mono'.}

\item{server}{[default "practice"] select either the "practice" or "live" server
depending on the account type held with OANDA.}

\item{apikey}{(optional) string containing the OANDA fxTrade API key (personal
access token), or function that returns this string. Does not need to be
specified if already stored by oanda_set_key(). Can also be entered
interactively if not specified.}

\item{...}{additional arguments passed along to \code{\link{ichimoku}} for
calculating the ichimoku cloud.}
}
\value{
Does not return a value, however a plot of the ichimoku chart for the
    price data requested is output to the graphical device at each refresh
    interval as a side effect. Note that returned times are represented in UTC.
}
\description{
Live updating Ichimoku Kinko Hyo cloud charts using OANDA fxTrade API data.
}
\details{
This function polls the OANDA fxTrade API for the latest live prices
    and updates the plot in the graphical device at each refresh interval.
    Use the 'Esc' key to stop updating.

    For further details please refer to the OANDA fxTrade API vignette by
    running: \code{vignette("xoanda", package = "ichimoku")}.
}
\examples{
\dontrun{
# OANDA fxTrade API key required to run this example
oanda_chart("USD_JPY")
oanda_chart("EUR_JPY", granularity = "H1", refresh = 3, count = 300, price = "B", theme = "mono")
}

}
