% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mkdir.R
\name{mkdir}
\alias{mkdir}
\title{Create Directory}
\usage{
mkdir(path)
}
\arguments{
\item{path}{a directory name.}
}
\value{
\code{TRUE} for success, \code{FALSE} for failure, invisibly.
}
\description{
Create directory, including parent directories if necessary, without
generating a warning if the directory already exists.
}
\examples{
\dontrun{
mkdir("emptydir")
rmdir("emptydir")

mkdir("outer/inner")
rmdir("outer", recursive=TRUE)
}

}
\seealso{
\code{\link{dir.create}} is the base function to create a new directory.

\code{\link{rmdir}} removes an empty directory.

\code{\link{clean}} can be used to remove non-empty directories.

\code{\link{icesTAF-package}} gives an overview of the package.
}
