% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download.R
\name{download}
\alias{download}
\title{Download File in Binary Mode}
\usage{
download(url, dir = ".", mode = "wb", chmod = file_ext(url) == "",
  quiet = TRUE, ...)
}
\arguments{
\item{url}{URL of file to download.}

\item{dir}{directory to download to.}

\item{mode}{download mode, see details.}

\item{chmod}{whether to set execute permission (default is \code{TRUE} if
file has no filename extension).}

\item{quiet}{whether to suppress messages.}

\item{\dots}{passed to \code{download.file}.}
}
\description{
Download a file in binary mode, e.g. a model executable.
}
\details{
With the default mode \code{"wb"} the file is downloaded in binary mode (see
\code{\link{download.file}}), to prevent R from adding \verb{^M} at line
ends. This is particularly relevant for Windows model executables, while the
\code{chmod} switch is useful when downloading Linux executables.

This function can be convenient for downloading any file, including text
files. Data files in CSV or other text format can also be read directly into
memory using \code{read.table}, \code{read.taf} or similar functions, without
writing to the file system.
}
\examples{
\dontrun{
url <- paste0("https://github.com/ices-taf/2015_had-iceg/raw/master/",
              "begin/model/catageysa.exe")
download(url)
}

}
\seealso{
\code{\link{read.taf}} reads a TAF table into a data frame.

\code{\link{icesTAF-package}} gives an overview of the package.
}
