% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sourceTAF.R
\name{sourceTAF}
\alias{sourceTAF}
\title{Run TAF Script}
\usage{
sourceTAF(script, rm = TRUE, quiet = FALSE)
}
\arguments{
\item{script}{script filename.}

\item{rm}{whether to remove all objects from the global environment before
the script is run.}

\item{quiet}{whether to suppress messages reporting progress.

By default, TAF scripts are run with \code{rm = TRUE} to make sure each
script starts with an empty workspace.}
}
\value{
Invisible \code{TRUE} or \code{FALSE}, indicating whether the script ran
without errors.
}
\description{
Run a TAF script and return to the original directory. Optionally start with
an empty workspace.
}
\note{
Commands within a script may change the working directory, but
\code{sourceTAF} guarantees that after running a script, the working
directory reported by \code{getwd()} is the same before and after running a
script.
}
\examples{
\dontrun{
write("print(pi)", "script.R")
source("script.R")
sourceTAF("script.R")
file.remove("script.R")
}

}
\seealso{
\code{\link{source}} is the base function to run R scripts.

\code{\link{make}} runs a TAF script if needed.

\code{\link{sourceAtoZ}} runs all TAF scripts in a directory.

\code{\link{icesTAF-package}} gives an overview of the package.
}
