% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cp.R
\name{cp}
\alias{cp}
\title{Copy Files}
\usage{
cp(from, to)
}
\arguments{
\item{from}{source file names. Multiple filenames can be matched using
wildcard notation, such as \code{*.csv} to copy all CSV files.}

\item{to}{destination file names, or directory.}
}
\value{
\code{TRUE} for success, \code{FALSE} for failure, invisibly.
}
\description{
Copy files, overwriting existing files if necessary, and returning the result
invisibly.
}
\note{
Shorthand for \code{invisible(file.copy(..., overwrite = TRUE))}.
}
\examples{
\dontrun{
write(pi, "A.txt")
cp("A.txt", "B.txt")
file.remove("A.txt", "B.txt")
}

}
\seealso{
\code{\link{file.copy}} is the base function to copy files.

\code{\link{icesTAF-package}} gives an overview of the package.
}
