#' @docType package
#'
#' @name icesDatras-package
#'
#' @aliases icesDatras
#'
#' @title DATRAS Trawl Database Web Services
#'
#' @description
#' R interface to access the web services of the ICES (International
#' Council for the Exploration of the Sea) DATRAS trawl database.
#'
#' @details
#' \emph{Get dataset:}
#' \tabular{ll}{
#'   \code{\link{getHHdata}} \tab haul data\cr
#'   \code{\link{getHLdata}} \tab length-based data\cr
#'   \code{\link{getCAdata}} \tab age-based data\cr
#'   \code{\link{getDATRAS}} \tab any data
#' }
#' \emph{Overview of available data:}
#' \tabular{ll}{
#'   \code{\link{getSurveyList}}            \tab surveys\cr
#'   \code{\link{getSurveyYearList}}        \tab years\cr
#'   \code{\link{getSurveyYearQuarterList}} \tab quarters\cr
#'   \code{\link{getDatrasDataOverview}}    \tab surveys, years, and quarters
#' }
#'
#' @author Colin Millar, Scott Large, and Arni Magnusson.
#'
#' @references
#' ICES DATRAS web services: \url{http://datras.ices.dk/}.

NA
