% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusterBootstrap.R
\name{ir_clustBoot}
\alias{ir_clustBoot}
\title{Updates the covariance using cluster bootstrap}
\usage{
ir_clustBoot(fit, ID, bs_samples = 1000)
}
\arguments{
\item{fit}{Either an ic_par or ic_sp model}

\item{ID}{Subject identifier}

\item{bs_samples}{Number of bootstrap samples}
}
\description{
Adjusts error estimates for repeated measures data by use of the cluster bootstrap.
}
\details{
Standard models in icenReg assume independence between each observation. 
This assumption is broken if we can have multiple observations from a single subject, 
which can lead to an underestimation of the standard errors. \code{ir_clustBoot}
addresses this by using a cluster bootstrap to fix up the standard errors. 

Note that this requires refitting the model \code{bs_samples}, which means this can be 
fairly time consuming.
}
\examples{
# Simulating repeated measures data 
simdata = simIC_cluster(nIDs = 10, nPerID = 4)

# Fitting with basic model
fit = ic_par(cbind(l,u) ~ x1 + x2, data = simdata)
fit

# Updating covariance
ir_clustBoot(fit, ID = simdata$ID, bs_samples = 10)
# (Low number of bootstrap samples used for quick testing by CRAN, 
# never use this few!!)

# Note that the SE's have changed from above
fit
}
\references{
Sherman, Michael, and Saskia le Cessie. 
"A comparison between bootstrap methods and 
generalized estimating equations for correlated 
outcomes in generalized linear models." 
Communications in Statistics-Simulation and Computation 26.3 (1997): 901-925.
}
