% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ic_bayes.R
\name{bayesControls}
\alias{bayesControls}
\title{Control parameters for ic_bayes}
\usage{
bayesControls(samples = 4000, chains = 4, useMLE_start = TRUE,
  burnIn = 2000, samplesPerUpdate = 1000, initSD = 0.1,
  updateChol = TRUE, acceptRate = 0.25, thin = 5)
}
\arguments{
\item{samples}{Number of samples.}

\item{chains}{Number of MCMC chains to run}

\item{useMLE_start}{Should MLE used for starting point?}

\item{burnIn}{Number of samples discarded for burn in}

\item{samplesPerUpdate}{Number of iterations between updates of proposal covariance matrix}

\item{initSD}{If \code{useMLE_start == FALSE}, initial standard deviation used}

\item{updateChol}{Should cholesky decomposition be updated?}

\item{acceptRate}{Target acceptance rate}

\item{thin}{Amount of thinning}
}
\description{
Control parameters for ic_bayes
}
\details{
Control parameters for the MH block updater used by \code{ic_bayes}.

The \code{samples} argument dictates how many MCMC samples are taken. One 
sample will be saved every \code{thin} iterations, so there will a total of
\code{thin * samples + burnIn} iterations. The burn in samples are not saved at all. 

Default behavior is to first calculate the MLE (not the MAP) estimate and use 
Hessian at the MLE to seed the proposal covariance matrix. After this, an updative 
covariance matrix is used. In cases with weakly informative likelihoods, 
using the MLE startpoint may lead to overly diffuse proposal or even undefined 
starting values. 
In this case, it suggested to use a cold start by setting \code{useMLE_start = F}
for the \code{controls} argument. In this case, the initial starting proposal
 covariance matrix will be a diagonal matrix with \code{initSD} standard deviations.
}
