% Generated by roxygen2 (4.0.1): do not edit by hand
\name{icd9Explain}
\alias{icd9Explain}
\alias{icd9Explain.character}
\alias{icd9Explain.list}
\alias{icd9Explain.numeric}
\alias{icd9ExplainDecimal}
\alias{icd9ExplainShort}
\title{explain ICD9 codes}
\usage{
icd9Explain(icd9, isShort, doCondense = TRUE)

icd9ExplainShort(icd9Short, doCondense = TRUE)

icd9ExplainDecimal(icd9Decimal, doCondense = TRUE)

\method{icd9Explain}{list}(icd9, isShort, doCondense = TRUE)

\method{icd9Explain}{character}(icd9, isShort, doCondense = TRUE)

\method{icd9Explain}{numeric}(icd9, isShort, doCondense = TRUE)
}
\arguments{
\item{icd9}{is a character vector of ICD-9 codes. If fewer than five characters is
given in a code, then the digits are greedily assigned to hundreds, then
tens, then units, before the decimal parts. E.g. "10" becomes "010", not
"0010"}

\item{icd9Short}{is a character vector of ICD-9 codes. If fewer than five characters is given
in a code, then the digits are greedily assigned to hundreds, then tens,
then units, before the decimal parts. E.g. "10" becomes "010", not "0010"}

\item{icd9Decimal}{character vector of ICD-9 codes. If fewer than five characters is given in a
code, then the digits are greedily assigned to hundreds, then tens, then
units, before the decimal parts. E.g. "10" becomes "010", not "0010"}

\item{isShort}{single logical value which determines whether the ICD-9 code provided is in short (TRUE) or decimal (FALSE) form.}

\item{doCondense}{single logical value which indicates whether to condense the given set of ICD-9 codes by replacing subsets of codes with 'parent' codes which exactly encompass certain subsets. E.g. If all cholera diagnoses are provided, only '001 - Cholera' needs to be displayed, not all subtypes. This is currently partially implemented. See issue #3 in github.}
}
\value{
data frame, or list of data frames, with fields for ICD9 code, name
  and description, derived from datamart lookup table
}
\description{
convert full format (123.45 style) ICD9 codes into the name and
  description for human review there are official ICD9-CM data tables, not
  with conversion to decimal notation, but to the textual format.
}
\section{Methods (by class)}{
\itemize{
\item \code{list}: explain alll ICD-9 codes in a list of vectors

\item \code{character}: explain character vector of ICD-9 codes

\item \code{numeric}: explain numeric vector of ICD-9 codes, with warning
}}
\note{
TODO: it will be useful to have S3 ICD-9 short and long classes for
  situations like this where we could easily dispatch on short or long type,
  or even use a print.icd9decimal or print.icd9Short S3 method to display
  ICD-9 codes.
}
\examples{
icd9ExplainShort(ahrqComorbid[[1]][1:3])
}
\references{
\url{http://www.stata.com/help.cgi?icd9}
}
\seealso{
package comorbidities
}

