% Generated by roxygen2 (4.0.1): do not edit by hand
\name{icd9Comorbidities}
\alias{icd9Comorbidities}
\alias{icd9ComorbiditiesNotPoa}
\alias{icd9ComorbiditiesPoa}
\title{merge comorbidities with icd9 codes per visitId (or other identity)}
\usage{
icd9Comorbidities(icd9df, visitId = "visitId", icd9Field = "icd9",
  icd9Mapping = ahrqComorbid, validateMapping = F, shortMapping = T)

icd9ComorbiditiesNotPoa(icd9df, icd9Mapping, visitId = "visitId",
  icd9Field = "icd9Code", poaField = "poa")

icd9ComorbiditiesPoa(icd9df, icd9Mapping, visitId = "visitId",
  icd9Field = "icd9Code", poaField = "poa")
}
\arguments{
\item{icd9df}{data.frame with fields specified by visitId and icd9Code.
icd9Code is assumed to be a non-decimal 'short' form ICD9 code. There is a
many to many ratio of icd9:visitId. This table contains multiple visitId
rows, with one row per ICD-9 code. Therefore, every ICD-9 code listed is
associated with at least one visit ID.}

\item{visitId}{The name of the column in the data frame which contains the
patient or visit identifier. Typically this is the visit identifier, since
patients come leave and enter hospital with different ICD-9 codes. It is a
character vector of length one. Defaults to "visitId"}

\item{icd9Field}{The column in the data frame which contains the ICD-9 codes.
This is a character vector of length one.}

\item{icd9Mapping}{list (or name of a list if character vector of length one
is given as argument) of the comorbidities with each top-level list item
containing a vector of decimal ICD9 codes. This is in the form of a list,
with the names of the items corresponding to the comorbidities (e.g. "HTN",
or "diabetes") and the contents of each list item being a character vector
of short-form (no decimal place but ideally zero left-padded) ICD-9 codes.}

\item{validateMapping}{logical, whether to validate all the ICD-9 codes in
the mapping list. Default is not to check. If validation fails, stop with
an error. This is probably worth doing at least once for each mapping used,
since there should never be an error in mapping. There is overhead to check
the mapping each time, so not done by default. Could consider using
\code{memoise} to cache the result of the check. (TODO)}

\item{shortMapping}{logical, whether the mapping is defined with short ICD-9
codes (TRUE, the default), or decimal if set to FALSE.}

\item{poaField}{The name of column in the data frame which contains the
Present On Arrival flag. The flag itself is a single character, typically
one of "Y", "N", "E", "X", "U" or empty. The poaField is a character vector
of length one.}
}
\description{
default comorbidity mapping is with AHRQ data. This is slow with
  long lists of patients, so intended to be used as intermediate step to save
  files like comorbidPoaInpt

this is not a simple binary, since many codes are exempt,
  unspecified, or unknown. Therefore, two options are given: get all the
  comorbidities where the POA flag was definitely -ve, coded as "N" or
  definitely +ve and coded as "Y". Negating one set won't give the other set
  unless all codes were either Y or N. #describeIn icd9Comorbidities

gets those comorbidities where the "Present on Arrival" (POA) flag is
  set to "Y"
}

