% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getDaily.R
\name{getDaily}
\alias{getDaily}
\title{Extracting Daily Climatic Variables}
\usage{
getDaily(sites, var, cv = FALSE)
}
\arguments{
\item{sites}{character. Names of sites from which to extract data.}

\item{var}{character. Climatic variable(s) to be extracted.}

\item{cv}{boolean. If \code{TRUE}, returns a data frame with coefficient of variation for each variable for each day of the calendar year. Default: FALSE.}
}
\value{
An object with specified climatic variables for names in \code{sites}.

If \code{cv = TRUE}, the object is a list containing two data frames: the first one with average daily values of climatic variables, and the second one with daily coefficient of variation for each climatic variable.

If \code{cv = FALSE}, the object is a data frame with average daily values of climatic variables.
}
\description{
this function extracts daily values of climatic variables from ICARDA Data, it returns a list or data frame based on specified climatic variables. Each variable will have 365 values for each day of the calendar year.
}
\details{
ICARDA data has to be accessible either from a local directory on the computer or from an online repository. \code{getDaily} will extract the climatic variables specified in \code{var} for the sites specified in \code{sites}.

For daily data, the function extracts average daily values starting from the first day of the calendar year, i.e. January 1, until the last day of the calendar year, i.e. December 31. Thus, 365 columns with daily values are created for each variable.
}
\examples{
if(interactive()){
 # Extract daily data for durum wheat
 durum <- getAccessions(crop = 'Durum wheat', coor = TRUE)
 daily <- getDaily(sites = levels(as.factor(durum$SiteCode)),
                   var = c('tavg', 'prec', 'rh'), cv = TRUE)

 # Get data frame with coefficient of variation from list object
 # returned (when cv = TRUE)
 daily.cv <- daily[[2]]
 }
}
\seealso{
\code{\link[reshape2]{cast}}
}
\author{
Zakaria Kehel, Bancy Ngatia
}
