% Generated by roxygen2 (4.0.2): do not edit by hand
\name{RandomMass}
\alias{RandomMass}
\title{Generating masses}
\usage{
RandomMass(nbFocalElement, ThetaSize, nbMass, Type, singleton)
}
\arguments{
\item{nbFocalElement}{The number of focal elements}

\item{ThetaSize}{The length of the discernment frame \eqn{\Theta}}

\item{nbMass}{The number of masses to generate}

\item{Type}{Which kind of mass to generate:

          Type=1 for focal elements can be evrywhere

          Type=2 for focal elements can not be on the emptyset

          Type=3 for no dogmatic mass : one focal element is on \eqn{\Theta} (ignorance)

          Type=4 for no dogmatic mass : one focal element is on \eqn{\Theta} (ignorance) and no focal elements are on the emptyset

          Type=5 for all the focal elements are the singletons

          Type=6 for all the focal elements are the singletons and on \eqn{\Theta} (ignorance)

          Type=7 for all the focal elements are the singletons and on \eqn{\Theta} (ignorance), but not on all the singletons

          Type=8 On only one defined singleton, on \eqn{\Theta} (ignorance), and others

          Type=9 On one defined singleton, on other singletons and on \eqn{\Theta} (ignorance)

          Type=10 On one focal element contain a defined singleton, on other focal elements and on \eqn{\Theta} (ignorance)

          Type=11 On one focal element contain a defined singleton, on other focal elements (not emptyset) and on
               \eqn{\Theta} (ignorance)}

\item{singleton}{The singleton element (with only one element) in the focal sets. It should be given if Type is from 5 to 11}
}
\value{
The generated mass matrix. Each column represenets a piece of mass
}
\description{
Different ways to generate masses
}
\examples{
RandomMass(nbFocalElement=3, ThetaSize=3, nbMass=4, Type=1)
RandomMass(nbFocalElement=3, ThetaSize=4, nbMass=4, Type=3)
RandomMass(nbFocalElement=4, ThetaSize=4, nbMass=4, Type=5,singleton=2)
RandomMass(nbFocalElement=4, ThetaSize=4, nbMass=4, Type=10,singleton=2)
}

